# delimit ;
capture log close;
set more 1;  
clear; 
set mem 300m; 
local divide 2; 
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;

*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
global folder "D:\Dropbox";
*global folder "C:\Dropbox\";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";

*global folder "C:\Dropbox\";
*"\\ad.ucl.ac.uk\homer\zctpmer\downloads";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
* 		 local wave13d "$folder\hrs\wave13_early\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";

         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";

*408C:following program added in this revision;
cap program  drop _getid_;
program define _getid_;
     version 6.0;
     gen temp=real(HHID);
     drop HHID;
     gen HHID=temp;
     drop temp;
     gen temp=real(PN);
     drop PN;
     gen PN=temp;
     drop temp;
     gen long HHIDPN=HHID*1000+PN;
     summ HHID PN HHIDPN;
     end;


*ahead 1;	 
	 
* this is for coding the employment data;
*408C:changed variable names to having capital letters to match new data;
*log using `saved'employ.log, replace ;
* first pull in the data;
use `aheadw1'BR21;
_getid_;
keep HHID PN V1178 OCCG3B V1186 V1187 V1188 V1189 V1190 V1197;
replace V1178=0 if V1178==.;
sort HHID PN;
save `saved'aemploy, replace;
drop _all;

* ahead 2;

*408C:replaced ahd2g.dta, which no longer exists, with A95G_R, the assumed new equivalent;
*use `ahead2d'ahd2g;
use `aheadw2'A95G_R;
_getid_;
keep HHID PN D2653 D2747 D2820M D3254M D2836 D3256 D2846 D3257 D2860 D2862 D2863 D2870
     D2880 D2881 D2885 D2886 D3260 D3261 D3262 D3264 D3265 D3266;
replace D2653=0 if D2653==.;
sort HHID PN;
merge HHID PN using `saved'aemploy;
drop _merge;
sort HHID PN; 
sleep 1000;
save `saved'aemploy, replace;
drop _all;

* wave 14;
use `wave14d'H18J_R;
gen HHID=hhid;
drop hhid;
gen PN=pn;
drop pn;
_getid_;
keep HHID PN QJ021 QJ045 QJ172 QJ179 QJ187 QJ188 QJ192 QJ194 QJ195 QJ199 QJ205 QJ206 QJ210 QJ216 QJ225 QJ226 QJ230 QJ231;
*clean up some mistakes in the data*;
*            24          -8.  Web non-response;
*            54         998.  DK (Don't Know)  NA (Not Ascertained);
*           150         999.  RF (Refused);
		   
*replace QJ216=. if (QJ216==99998|QJ216==99999);
replace QJ216=. if (QJ216==9998|QJ216==9999 | QJ216==-8);
tab QJ216;
replace QJ021=0 if QJ021==.;
sort HHID PN;
save `saved'employ, replace;
drop _all;

* wave 15;
if $INCLUDE2020 {; 
disp "Doing 2020 processing..." ;
use `wave15d'H20J_R;
gen HHID=hhid;
drop hhid;
gen PN=pn;
drop pn;
_getid_;
keep HHID PN RJ021 RJ045 RJ172 RJ179 RJ187 RJ188 RJ192 RJ194 RJ195 RJ199 RJ205 RJ206 RJ210 RJ216 RJ225 RJ226 RJ230 RJ231;
*clean up some mistakes in the data*;
*            31          -8.  Web non-response;
*            59        9998.  DK (Don't Know) NA (Not Ascertained);
*           136        9999.  RF (Refused);

*replace RJ216=. if (RJ216==99998|RJ216==99999);
replace RJ216=. if (RJ216==9998|RJ216==9999 | RJ216==-8);
tab RJ216;
replace RJ021=0 if RJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;
};

* wave 13;
use `wave13d'H16J_R;
_getid_;
keep HHID PN PJ021 PJ045 PJ172 PJ179 PJ187 PJ188 PJ192 PJ194 PJ195 PJ199 PJ205 PJ206 PJ210 PJ216 PJ225 PJ226 PJ230 PJ231;

*clean up some mistakes in the data*;
*            95         998.  DK (Don't Know)  NA (Not Ascertained);
*           194         999.  RF (Refused);
   
replace PJ216=. if (PJ216==99998|PJ216==99999);
tab PJ216;

replace PJ021=0 if PJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;
* wave 12;


use `wave12d'H14J_R;
_getid_;
keep HHID PN OJ021 OJ045 OJ172 OJ179 OJ187 OJ188 OJ192 OJ194 OJ195 OJ199 OJ205 OJ206 OJ210 OJ216 OJ225 OJ226 OJ230 OJ231;
*clean up some mistakes in the data*;
replace OJ216=. if (OJ216==99998|OJ216==99999);
tab OJ216;

replace OJ021=0 if OJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;


* wave 11;

use `wave11d'H12J_R;
_getid_;
keep HHID PN NJ021 NJ045 NJ172 NJ179 NJ187 NJ188 NJ192 NJ194 NJ195 NJ199 NJ205 NJ206 NJ210 NJ216 NJ225 NJ226 NJ230 NJ231;

*clean up some mistakes in the data*;
*           118        9998.  DK (Don't Know)  NA (Not Ascertained);
*           162        9999.  RF (Refused);

replace NJ216=. if (NJ216==99999998|NJ216==99999999);
tab NJ216;

replace NJ021=0 if NJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;






use `wave10d'H10J_R;
_getid_;
keep HHID PN MJ021 MJ045 MJ172 MJ179 MJ187 MJ188 MJ192 MJ194 MJ195 MJ199 MJ205 MJ206 MJ210 MJ216 MJ225 MJ226 MJ230 MJ231;

*clean up some mistakes in the data*;
replace MJ216=. if (MJ216==99999998|MJ216==99999999);
tab MJ216;

replace MJ021=0 if MJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;


use `wave9d'H08J_R;
_getid_;
keep HHID PN LJ021 LJ045 LJ172 LJ179 LJ187 LJ188 LJ192 LJ194 LJ195 LJ199 LJ205 LJ206 LJ210 LJ216 LJ225 LJ226 LJ230 LJ231;

*clean up some mistakes in the data*;
replace LJ216=. if (LJ216==999999998|LJ216==999999999);
tab LJ216;

replace LJ021=0 if LJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;

use `wave8d'H06J_R;
_getid_;
keep HHID PN KJ021 KJ045 KJ172 KJ179 KJ187 KJ188 KJ192 KJ194 KJ195 KJ199 KJ205 KJ206 KJ210 KJ216 KJ225 KJ226 KJ230 KJ231;

*clean up some mistakes in the data*;
replace KJ216=. if (KJ216==999999998|KJ216==999999999);
tab KJ216;

replace KJ021=0 if KJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;

use `wave7d'H04J_R;
_getid_;
keep HHID PN JJ021 JJ045 JJ172 JJ179 JJ187 JJ188 JJ192 JJ194 JJ195 JJ199 JJ205 JJ206 JJ210 JJ216 JJ225 JJ226 JJ230 JJ231;

*clean up some mistakes in the data*;
replace JJ216=. if (JJ216==1000000);
tab JJ216;

replace JJ021=0 if JJ021==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;

*408C:added wave6;
use `wave6d'H02J_R;
_getid_;
keep HHID PN HJ021 HJ045 HJ172 HJ179 HJ187 HJ188 HJ192 HJ194 HJ195 HJ199 HJ205 HJ206 HJ210 HJ216 HJ225 HJ226 HJ230 HJ231;

*clean up some mistakes in the data*;
replace HJ216=. if (HJ216>99999);
tab HJ216;

replace HJ021=0 if HJ021==.; *408C:mimicking the wave5 section in which Q3382, the equivalent of this variable, has this replacement;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;

*408C:replaced h00_g, which no longer exists, with H00G_R, the assumed new equivalent;
use `wave5d'H00G_R;
*use `wave5d'h00_g;
_getid_;
*408C:renamed following variables from the new data (with G prefix) to having Q prefix, as in the old data;
*408C:all renamings are for variables with identical labels;
rename G3382 Q3382;
rename G3416 Q3416;
rename G3509 Q3509;
rename G3519 Q3519;
rename G3539 Q3539;
rename G3540 Q3540;
rename G3541 Q3541;
rename G3543 Q3543;
rename G3544 Q3544;
rename G3545 Q3545;
rename G3555 Q3555;
rename G3557 Q3557;
rename G3558 Q3558;
rename G3564 Q3564;
rename G3574 Q3574;
rename G3575 Q3575;
rename G3579 Q3579;
rename G3580 Q3580;
keep HHID PN Q3382 Q3416 Q3509 Q3519 Q3539-Q3545 Q3555 Q3557 Q3558 Q3564 Q3574 Q3575 Q3579 Q3580;
*Q3382- g3, work for someone else/self-employed, Q3416- still working prev employer;
*Q3509- g44, hours work per week, Q3519- g47, weeks per year usually work;
*Q3539- g52, paid regular salary/wages, Q3540- g52a self-employment salary-amount;
*Q3541- g52b self employment salary per, Q3543- g53 receive net earnings/profits;
*NOT SURE WHAT Q3542 IS!!! POSSIBLE ERROR IN PREVIOUS SCRIPT;
*Q3544- g53a net earnings/profit amount Q3545- g53b net earnings/profits per;
*Q3555- g56 how paid on job, Q3557- g56a amount salary, Q3558- g56b per;
*Q3564- g56f hourly wage rate, Q3574- g56m amount per time period, Q3575- g56n per;
*Q3579- g56r amount paid, Q3580- g56s per;
replace Q3382=0 if Q3382==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN;
save `saved'employ, replace;
drop _all;

*408C:replaced hrs98g.dta, which no longer exists, with H98G_R, the assumed new equivalent;
use `wave4d'H98G_R;
*use `wave4d'hrs98g;
_getid_;
*408C:renamed following variables from the new data (with F prefix) to having Q prefix, as in the old data;
*408C:all renamings are for variables with identical labels;
rename F3132 Q3132;
rename F3166 Q3166;
rename F3259 Q3259;
rename F3269 Q3269;
rename F3279 Q3279;
rename F3280 Q3280;
rename F3281 Q3281;
rename F3283 Q3283;
rename F3284 Q3284;
rename F3285 Q3285;
rename F3295 Q3295;
rename F3297 Q3297;
rename F3298 Q3298; *408C:F3298 is labeled "AMOUNT SALARY-PER", Q3298 is labeled "PER";
rename F3304 Q3304;
rename F3314 Q3314;
rename F3315 Q3315; *408C:F3315 is labeled "AMOUNT PER TIME PERIOD-PER", Q3315 is labeled "PER";
rename F3319 Q3319;
rename F3320 Q3320; *408C:F3320 is labeled "AMOUNT PAID-PER", Q3320 is labeled "PER";
keep HHID PN Q3132 Q3166 /*Q3254 Q3253*/ Q3259 Q3269 Q3279-Q3285 Q3295 Q3297 Q3298 Q3304 Q3314 
            Q3315 Q3319 Q3320 ;
replace Q3132=0 if Q3132==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN; 
save `saved'employ, replace;
drop _all;


*408C:variables named have matches in H96G_R file;
*408C:renamed variables from the new data (with E prefix) to having Q prefix, as in all of the variables in the old "w3g" file, which presumably w3_gnew is based upon;
*408C:could not compare labels of old variable (Q prefix) with new variable (E prefix) because the w3g file is lacking the variables with these numbers;
*408C:replaced w3g, which no longer exits, with H96G_R, the assumed new equivalent;

use `wave3d'H96G_R;
_getid_;
*408C:renamed following variables from the new data (with E prefix) to having Q prefix, as in the old data;
*408C:all renamings are for variables with identical labels;
rename E2628 Q2628;
rename E2655 Q2655;
rename E2736 Q2736;
rename E2746 Q2746;
rename E2757 Q2757;
rename E2758 Q2758;
rename E2761 Q2761;
rename E2762 Q2762;
rename E2772 Q2772;
rename E2774 Q2774;
rename E2775 Q2775; 
rename E2781 Q2781;
rename E2791 Q2791;
rename E2792 Q2792;
rename E2796 Q2796; 
rename E2797 Q2797; 
keep HHID PN Q2628 Q2655 Q2736 Q2746 Q2757 Q2758 Q2761 Q2762 Q2772 Q2774 Q2775 
	Q2781 Q2791 Q2792 Q2796 Q2797;
replace Q2628=0 if Q2628==.;

sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN; 
save `saved'employ, replace;
drop _all;


use `wave2d'w2fa;
_getid_;
keep HHID PN W3317 W3458 W3609 W3608 W3617 W3623 W3631 W3632 W3633 W3637 W3642 
            W3643 W3645 W3646;
replace W3317=0 if W3317==.;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN; 
save `saved'employ, replace;
drop _all;

use `wave2d'w2fb; *self-employed;
_getid_;
*408C:rename CSUBHH (new variable) as W2SUBHH (old name), both indicate 1994 sub-household identifier;
rename CSUBHH W2SUBHH;
keep HHID PN W2SUBHH W4312A W4312B W4313-W4328;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN; 
save `saved'employ, replace;
drop _all;


*now merge wave1 files;

use `wave1d'employer;
_getid_;
keep HHID PN V2718 V2720 V2719 V2722 V2726 V2734 V2735 V2736 V2739 V2743 V2744 
            V2748 V2749 V2820 V2821 V2822 V2823 V2825 V2826 V2828 V2829;
replace V2718=0 if V2718==.;

sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;
sort HHID PN; 
save `saved'employ, replace;
* end of waves *******************************************************;


* this generates a variable=1 if working for someone else, 2 if for self, . if not working;
gen work1=.;
replace work1=V2718 if V2718==1|V2718==2;
gen work2=.;
replace work2=W3317 if W3317==1|W3317==2;
gen work3=.;
replace work3=Q2628 if Q2628==1|Q2628==2;
gen work4=.;
replace work4=Q3132 if Q3132==1|Q3132==2;
gen work5=.;
replace work5=Q3382 if Q3382==1|Q3382==2;
gen work6=.;
replace work6=HJ021 if HJ021==1|HJ021==2;
gen work7=.;
replace work7=JJ021 if JJ021==1|JJ021==2;
gen work8=.;
replace work8=KJ021 if KJ021==1|KJ021==2;
gen work9=.;
replace work9=LJ021 if LJ021==1|LJ021==2;
gen work10=.;
replace work10=MJ021 if MJ021==1|MJ021==2;
gen work11=.;
replace work11=NJ021 if NJ021==1|NJ021==2;
gen work12=.;
replace work12=OJ021 if OJ021==1|OJ021==2;
gen work13=.;
replace work13=PJ021 if PJ021==1|PJ021==2;
gen work14=.;
replace work14=QJ021 if QJ021==1|QJ021==2;
if $INCLUDE2020 {; 
gen work15=.;
replace work15=RJ021 if RJ021==1|RJ021==2;
};


*still working for same employer? ;
gen same1=.;
gen same2=W3458;
replace same2=0 if same2~=1;
gen same3=Q2655;
replace same3=0 if same3~=1;
gen same4=Q3166;
replace same4=0 if same4~=1;
gen same5=Q3416;
replace same5=0 if same5~=1;
gen same6=HJ045;
replace same6=0 if same6~=1;
gen same7=JJ045;
replace same7=0 if same7~=1;
gen same8=KJ045;
replace same8=0 if same8~=1;
gen same9=LJ045;
replace same9=0 if same9~=1;
gen same10=MJ045;
replace same10=0 if same10~=1;
gen same11=NJ045;
replace same11=0 if same11~=1;
gen same12=OJ045;
replace same12=0 if same12~=1;
gen same13=PJ045;
replace same13=0 if same13~=1;
gen same14=QJ045;
replace same14=0 if same14~=1;
if $INCLUDE2020 {; 
gen same15=RJ045;
replace same15=0 if same15~=1;
};


* occupational code;
gen occ1=V2720;
gen occ2=W3609;
gen occ3=.;
gen occ4=.;
gen occ5=.;
gen occ6=.;
gen occ7=.;
gen occ8=.;
gen occ9=.;
gen occ10=.;
gen occ11=.;
gen occ12=.;
gen occ13=.;
gen occ14=.;
if $INCLUDE2020 {; 
gen occ15=.;
};
*gen occ3=Q2731;
*gen occ4=Q3254;
*gen occ5=_____;
*occupation of the self-employed;
replace occ1=V2821 if work1==2;
replace occ2=W4312B if work2==2;
replace occ1=. if occ1==999;
replace occ2=. if occ2==999;
replace occ2=occ1 if same2==1;
replace occ3=occ2 if same3==1;
replace occ4=occ3 if same4==1;
replace occ5=occ4 if same5==1;
replace occ6=occ5 if same6==1;
replace occ7=occ6 if same7==1;
replace occ8=occ7 if same8==1;
replace occ9=occ8 if same9==1;
replace occ10=occ9 if same10==1;
replace occ11=occ10 if same11==1;
replace occ12=occ11 if same12==1;
replace occ13=occ12 if same13==1;
replace occ14=occ13 if same14==1;
if $INCLUDE2020 {; 
replace occ15=occ13 if same15==1;
};
* industry code;
gen ind1=V2719;
gen ind2=W3608;
*gen ind3=Q2730;
*gen ind4=Q3253;
gen ind3=.;
gen ind4=.;
gen ind5=.;
gen ind6=.;
gen ind7=.;
gen ind8=.;
gen ind9=.;
gen ind10=.;
gen ind11=.;
gen ind12=.;
gen ind13=.;
gen ind14=.;
if $INCLUDE2020 {; 
gen ind15=.;
};
*industry of self-employed;
replace ind1=V2820 if work1==2;
replace ind2=W4312A if work2==2;
replace ind1=. if ind1==999;
replace ind2=. if ind2==999;
replace ind2=ind1 if same2==1;
replace ind3=ind2 if same3==1;
replace ind4=ind3 if same4==1;
replace ind5=ind4 if same5==1;
replace ind6=ind5 if same6==1;
replace ind7=ind6 if same7==1;
replace ind8=ind7 if same8==1;
replace ind9=ind8 if same9==1;
replace ind10=ind9 if same10==1;
replace ind11=ind10 if same11==1;
replace ind12=ind11 if same12==1;
replace ind13=ind12 if same13==1;
replace ind14=ind13 if same14==1;
if $INCLUDE2020 {; 
replace ind15=ind14 if same14==1;
};

* hours worked per year;
gen hours1=V2722;
gen weeks1=V2726;
tab weeks1;
gen hours2=W3617;
tab hours2;
gen weeks2=W3623;
gen hours3=Q2736;
gen weeks3=Q2746;
gen hours4=Q3259;
gen weeks4=Q3269;
gen hours5=Q3509;
gen weeks5=Q3519;
gen hours6=HJ172;
gen weeks6=HJ179;
gen hours7=JJ172;
gen weeks7=JJ179;
gen hours8=KJ172;
gen weeks8=KJ179;
gen hours9=LJ172;
gen weeks9=LJ179;
gen hours10=MJ172;
gen weeks10=MJ179;
gen hours11=NJ172;
gen weeks11=NJ179;
gen hours12=OJ172;
gen weeks12=OJ179;
gen hours13=PJ172;
gen weeks13=PJ179;
gen hours14=QJ172;
gen weeks14=QJ179;
if $INCLUDE2020 {; 
gen hours15=RJ172;
gen weeks15=RJ179;
};

******recode hours and weeks to get an annual hours variable ********;

* In waves 1 and 2 the self employed were done seperately;
replace hours1=V2822 if work1==2;
tab weeks1;
replace weeks1=V2823 if work1==2;
tab weeks1;
replace hours2=W4313 if work2==2;
tab hours2;
replace weeks2=W4314 if work2==2;
******recode hours and weeks to get an annual hours variable ********;
replace hours1=. if hours1>95;
replace hours1=0 if V2718==0; 
* not working;
tab weeks1;
replace weeks1=. if weeks1>52;
tab weeks1;
replace weeks1=0 if hours1==0;
tab weeks1;
replace hours1=hours1*weeks1;
replace hours1=0 if (hours1>0 & hours1<300);
replace hours2=. if hours2>95;
replace hours2=0 if W3317==0;
replace weeks2=. if weeks2>52;
replace weeks2=0 if hours2==0;
replace hours2=hours2*weeks2;
replace hours2=0 if (hours2>0 & hours2<300);


replace hours3=. if hours3>95;
replace hours3=0 if Q2628==0;

replace weeks3=. if weeks3>52;
replace weeks3=0 if hours3==0;
tab weeks3;
replace hours3=hours3*weeks3;
tab hours3;
replace hours3=0 if (hours3>0 & hours3<300);
replace hours4=. if hours4>95;
replace hours4=0 if Q3132==0;
replace weeks4=. if weeks4>52;
replace weeks4=0 if hours4==0;
replace hours4=hours4*weeks4;
replace hours4=0 if (hours4>0 & hours4<300);
replace hours5=. if hours5>95;
replace hours5=0 if Q3382==0;
replace weeks5=. if weeks5>52;
replace weeks5=0 if hours5==0;
replace hours5=hours5*weeks5;
replace hours5=0 if (hours5>0 & hours5<300);
replace hours6=. if hours6>95;
replace hours6=0 if HJ021==0;
replace weeks6=. if weeks6>52;
replace weeks6=0 if hours6==0;
replace hours6=hours6*weeks6;
replace hours6=0 if (hours6>0 & hours6<300);
replace hours7=. if hours7>95;
replace hours7=0 if JJ021==0;
replace weeks7=. if weeks7>52;
replace weeks7=0 if hours7==0;
replace hours7=hours7*weeks7;
replace hours7=0 if (hours7>0 & hours7<300);
replace hours8=. if hours8>95;
replace hours8=0 if KJ021==0;
replace weeks8=. if weeks8>52;
replace weeks8=0 if hours8==0;
replace hours8=hours8*weeks8;
replace hours8=0 if (hours8>0 & hours8<300);
replace hours9=. if hours9>95;
replace hours9=0 if LJ021==0;
replace weeks9=. if weeks9>52;
replace weeks9=0 if hours9==0;
replace hours9=hours9*weeks9;
replace hours9=0 if (hours9>0 & hours9<300);
replace hours10=. if hours10>95;
replace hours10=0 if MJ021==0;
replace weeks10=. if weeks10>52;
replace weeks10=0 if hours10==0;
replace hours10=hours10*weeks10;
replace hours10=0 if (hours10>0 & hours10<300);
replace hours11=. if hours11>95;
replace hours11=0 if NJ021==0;
replace weeks11=. if weeks11>52;
replace weeks11=0 if hours11==0;
replace hours11=hours11*weeks11;
replace hours11=0 if (hours11>0 & hours11<300);
replace hours12=. if hours12>95;
replace hours12=0 if OJ021==0;
replace weeks12=. if weeks12>52;
replace weeks12=0 if hours12==0;
replace hours12=hours12*weeks12;
replace hours12=0 if (hours12>0 & hours12<300);
replace hours13=. if hours13>95;
replace hours13=0 if PJ021==0;
replace weeks13=. if weeks13>52;
replace weeks13=0 if hours13==0;
replace hours13=hours13*weeks13;
replace hours13=0 if (hours13>0 & hours13<300);
replace hours14=. if hours14>95;
replace hours14=0 if QJ021==0;
replace weeks14=. if weeks14>52;
replace weeks14=0 if hours14==0;
replace hours14=hours14*weeks14;
replace hours14=0 if (hours14>0 & hours14<300);
if $INCLUDE2020 {; 
replace hours15=. if hours15>95;
replace hours15=0 if RJ021==0;
replace weeks15=. if weeks15>52;
replace weeks15=0 if hours15==0;
replace hours15=hours15*weeks15;
replace hours15=0 if (hours15>0 & hours15<300);
};

gen wkrat1=weeks1/52;
gen wkrat2=weeks2/52;
gen wkrat3=weeks3/52;
gen wkrat4=weeks4/52;
gen wkrat5=weeks5/52;
gen wkrat6=weeks6/52;
gen wkrat7=weeks7/52;
gen wkrat8=weeks8/52;
gen wkrat9=weeks9/52;
gen wkrat10=weeks10/52;
gen wkrat11=weeks11/52;
gen wkrat12=weeks12/52;
gen wkrat13=weeks13/52;
gen wkrat14=weeks14/52;
if $INCLUDE2020 {; 
gen wkrat15=weeks15/52;
};
gen lfpr1=0;
replace lfpr1=1 if hours1>1;
replace lfpr1=. if hours1==.;
gen lfpr2=0;
replace lfpr2=1 if hours2>1;
replace lfpr2=. if hours2==.;
gen lfpr3=0;
replace lfpr3=1 if hours3>1;
replace lfpr3=. if hours3==.;
gen lfpr4=0;
replace lfpr4=1 if hours4>1;
replace lfpr4=. if hours4==.;
gen lfpr5=0;
replace lfpr5=1 if hours5>1;
replace lfpr5=. if hours5==.;
gen lfpr6=0;
replace lfpr6=1 if hours6>1;
replace lfpr6=. if hours6==.;
gen lfpr7=0;
replace lfpr7=1 if hours7>1;
replace lfpr7=. if hours7==.;
gen lfpr8=0;
replace lfpr8=1 if hours8>1;
replace lfpr8=. if hours8==.;
gen lfpr9=0;
replace lfpr9=1 if hours9>1;
replace lfpr9=. if hours9==.;
gen lfpr10=0;
replace lfpr10=1 if hours10>1;
replace lfpr10=. if hours10==.;
gen lfpr11=0;
replace lfpr11=1 if hours11>1;
replace lfpr11=. if hours11==.;
gen lfpr12=0;
replace lfpr12=1 if hours12>1;
replace lfpr12=. if hours12==.;
gen lfpr13=0;
replace lfpr13=1 if hours13>1;
replace lfpr13=. if hours13==.;
gen lfpr14=0;
replace lfpr14=1 if hours14>1;
replace lfpr14=. if hours14==.;
if $INCLUDE2020 {; 
gen lfpr15=0;
replace lfpr15=1 if hours15>1;
replace lfpr15=. if hours15==.;
};

* how paid? ;
gen pay1=V2734;
gen pay2=W3631;
gen pay3=Q2772;
gen pay4=Q3295;
gen pay5=Q3555;
gen pay6=HJ205;
gen pay7=JJ205;
gen pay8=KJ205;
gen pay9=LJ205;
gen pay10=MJ205;
gen pay11=NJ205;
gen pay12=OJ205;
gen pay13=PJ205;
gen pay14=QJ205;
if $INCLUDE2020 {; 
gen pay15=RJ205;
};
* if salaried, labor income on main job;
gen sal1=.;
replace sal1=V2735 if V2735<9999995 & V2735>0;
replace sal1=sal1*52*wkrat1 if V2736==2;
replace sal1=sal1*26*wkrat1 if V2736==3;
replace sal1=sal1*12*wkrat1 if V2736==4;
replace sal1=sal1 if V2736==6;
replace sal1=. if V2736>6|V2736<2;

gen sal2=.;
replace sal2=W3632 if W3632<9999995 & W3632>0;
replace sal2=sal2*hours2 if W3633==1;
replace sal2=sal2*52*wkrat2 if W3633==2;
replace sal2=sal2*26*wkrat2 if W3633==3;
replace sal2=sal2*12*wkrat2 if W3633==4;
replace sal2=sal2*24*wkrat2 if W3633==5;
replace sal2=sal2 if W3633==6;
replace sal2=sal2*weeks2*5 if W3633==11;
replace sal2=. if W3633>11|W3633<1;

gen sal3=.;
replace sal3=Q2774 if Q2774<9999997 & Q2774>0;
replace sal3=sal3*hours3 if Q2775==1;
replace sal3=sal3*52*wkrat3 if Q2775==2;
replace sal3=sal3*26*wkrat3 if Q2775==3;
replace sal3=sal3*12*wkrat3 if Q2775==4;
replace sal3=sal3*24*wkrat3 if Q2775==5;
replace sal3=sal3 if Q2775==6;
replace sal3=sal3*weeks3*5 if Q2775==11;
replace sal3=. if Q2775>11|Q2775<1;

gen sal4=.;
replace sal4=Q3297 if Q3297<9999995 & Q3297>0;
replace sal4=sal4*hours4 if Q3298==1;
replace sal4=sal4*52*wkrat4 if Q3298==2;
replace sal4=sal4*26*wkrat4 if Q3298==3;
replace sal4=sal4*12*wkrat4 if Q3298==4;
replace sal4=sal4*24*wkrat4 if Q3298==5;
replace sal4=sal4 if Q3298==6;
replace sal4=. if Q3298>6|Q3298<1;

gen sal5=.;
replace sal5=Q3557 if Q3557<9999995 & Q3557>0;
replace sal5=sal5*hours5 if Q3558==1;
replace sal5=sal5*52*wkrat5 if Q3558==2;
replace sal5=sal5*26*wkrat5 if Q3558==3;
replace sal5=sal5*12*wkrat5 if Q3558==4;
replace sal5=sal5*24*wkrat5 if Q3558==5;
replace sal5=sal5 if Q3558==6;
replace sal5=. if Q3558>6|Q3558<1;

gen sal6=.;
replace sal6=HJ206 if HJ206<9999995 & HJ206>0;
replace sal6=sal6*hours6 if HJ210==1;
replace sal6=sal6*52*wkrat6 if HJ210==2;
replace sal6=sal6*26*wkrat6 if HJ210==3;
replace sal6=sal6*12*wkrat6 if HJ210==4;
replace sal6=sal6*24*wkrat6 if HJ210==5;
replace sal6=sal6 if HJ210==6;
replace sal6=. if HJ210>6|HJ210<1;

gen sal7=.;
replace sal7=JJ206 if JJ206<9999995 & JJ206>0;
replace sal7=sal7*hours7 if JJ210==1;
replace sal7=sal7*52*wkrat7 if JJ210==2;
replace sal7=sal7*26*wkrat7 if JJ210==3;
replace sal7=sal7*12*wkrat7 if JJ210==4;
replace sal7=sal7*24*wkrat7 if JJ210==5;
replace sal7=sal7 if JJ210==6;
replace sal7=. if JJ210>6|JJ210<1;

gen sal8=.;
replace sal8=KJ206 if KJ206<9999995 & KJ206>0;
replace sal8=sal8*hours8 if KJ210==1;
replace sal8=sal8*52*wkrat8 if KJ210==2;
replace sal8=sal8*26*wkrat8 if KJ210==3;
replace sal8=sal8*12*wkrat8 if KJ210==4;
replace sal8=sal8*24*wkrat8 if KJ210==5;
replace sal8=sal8 if KJ210==6;
replace sal8=. if KJ210>6|KJ210<1;

gen sal9=.;
replace sal9=LJ206 if LJ206<9999995 & LJ206>0;
replace sal9=sal9*hours9 if LJ210==1;
replace sal9=sal9*52*wkrat9 if LJ210==2;
replace sal9=sal9*26*wkrat9 if LJ210==3;
replace sal9=sal9*12*wkrat9 if LJ210==4;
replace sal9=sal9*24*wkrat9 if LJ210==5;
replace sal9=sal9 if LJ210==6;
replace sal9=. if LJ210>6|LJ210<1;

gen sal10=.;
replace sal10=MJ206 if MJ206<9999995 & MJ206>0;
replace sal10=sal10*hours10 if MJ210==1;
replace sal10=sal10*52*wkrat10 if MJ210==2;
replace sal10=sal10*26*wkrat10 if MJ210==3;
replace sal10=sal10*12*wkrat10 if MJ210==4;
replace sal10=sal10*24*wkrat10 if MJ210==5;
replace sal10=sal10 if MJ210==6;
replace sal10=. if MJ210>6|MJ210<1;


gen sal11=.;
replace sal11=NJ206 if NJ206<9999995 & NJ206>0;
replace sal11=sal11*hours11 if NJ210==1;
replace sal11=sal11*52*wkrat11 if NJ210==2;
replace sal11=sal11*26*wkrat11 if NJ210==3;
replace sal11=sal11*12*wkrat11 if NJ210==4;
replace sal11=sal11*24*wkrat11 if NJ210==5;
replace sal11=sal11 if NJ210==6;
replace sal11=. if NJ210>6|NJ210<1;

gen sal12=.;
replace sal12=OJ206 if OJ206<9999995 & OJ206>0;
replace sal12=sal12*hours12 if OJ210==1;
replace sal12=sal12*52*wkrat12 if OJ210==2;
replace sal12=sal12*26*wkrat12 if OJ210==3;
replace sal12=sal12*12*wkrat12 if OJ210==4;
replace sal12=sal12*24*wkrat12 if OJ210==5;
replace sal12=sal12 if OJ210==6;
replace sal12=. if OJ210>6|OJ210<1;

gen sal13=.;
replace sal13=PJ206 if PJ206<9999995 & PJ206>0;
replace sal13=sal13*hours13 if PJ210==1;
replace sal13=sal13*52*wkrat13 if PJ210==2;
replace sal13=sal13*26*wkrat13 if PJ210==3;
replace sal13=sal13*12*wkrat13 if PJ210==4;
replace sal13=sal13*24*wkrat13 if PJ210==5;
replace sal13=sal13 if PJ210==6;
replace sal13=. if PJ210>6|PJ210<1;
gen sal14=.;
replace sal14=QJ206 if QJ206<9999995 & QJ206>0;
replace sal14=sal14*hours14 if QJ210==1;
replace sal14=sal14*52*wkrat14 if QJ210==2;
replace sal14=sal14*26*wkrat14 if QJ210==3;
replace sal14=sal14*12*wkrat14 if QJ210==4;
replace sal14=sal14*24*wkrat14 if QJ210==5;
replace sal14=sal14 if QJ210==6;
replace sal14=. if QJ210>6|QJ210<1;
if $INCLUDE2020 {; 
gen sal15=.;
replace sal15=RJ206 if RJ206<9999995 & RJ206>0;
replace sal15=sal15*hours15 if RJ210==1;
replace sal15=sal15*52*wkrat15 if RJ210==2;
replace sal15=sal15*26*wkrat15 if RJ210==3;
replace sal15=sal15*12*wkrat15 if RJ210==4;
replace sal15=sal15*24*wkrat15 if RJ210==5;
replace sal15=sal15 if RJ210==6;
replace sal15=. if RJ210>6|RJ210<1;
};


gen wsal1=sal1/hours1;
gen wsal2=sal2/hours2;
gen wsal3=sal3/hours3;
gen wsal4=sal4/hours4;
gen wsal5=sal5/hours5;
gen wsal6=sal6/hours6;
gen wsal7=sal7/hours7;
gen wsal8=sal8/hours8;
gen wsal9=sal9/hours9;
gen wsal10=sal10/hours10;
gen wsal11=sal11/hours11;
gen wsal12=sal12/hours12;
gen wsal13=sal13/hours13;
gen wsal14=sal14/hours14;
if $INCLUDE2020 {; 
gen wsal15=sal15/hours15;
};
* if hourly, pay for regular time work;
gen whourly1=V2739;

*clean up some mistakes in the data;
replace W3637=. if (W3637==9994|W3637==99940|W3637==99940|W3637==25000|W3637==99950);

gen whourly2=W3637;
gen whourly3=Q2781;
gen whourly4=Q3304;
gen whourly5=Q3564;
gen whourly6=HJ216;
gen whourly7=JJ216;
gen whourly8=KJ216;
gen whourly9=LJ216;
gen whourly10=MJ216;
gen whourly11=NJ216;
gen whourly12=OJ216;
gen whourly13=PJ216;
gen whourly14=QJ216;
if $INCLUDE2020 {; 
gen whourly15=RJ216;
};
replace whourly1=. if whourly1>5000|whourly1==0; 
replace whourly2=. if whourly2>=5000|whourly2==0;
replace whourly3=. if whourly3>5000|whourly3==0;
replace whourly4=. if whourly4>5000|whourly4==0;
replace whourly5=. if whourly5>5000|whourly5==0;
replace whourly6=. if whourly6>5000|whourly6==0;
replace whourly7=. if whourly7>5000|whourly7==0;
replace whourly8=. if whourly8>5000|whourly8==0;
replace whourly9=. if whourly9>5000|whourly9==0;
replace whourly10=. if whourly10>5000|whourly10==0;
replace whourly11=. if whourly11>5000|whourly11==0;
replace whourly12=. if whourly12>5000|whourly12==0;
replace whourly13=. if whourly13>5000|whourly13==0;
replace whourly14=. if whourly14>5000|whourly14==0;
if $INCLUDE2020 {; 
replace whourly15=. if whourly15>5000|whourly15==0;
};

* if on piecework\commision;

gen piece1=.;
replace piece1=V2743 if V2743<9999997 & V2743>0;
replace piece1=piece1*52*wkrat1 if V2744==2; 
replace piece1=piece1*26*wkrat1 if V2744==3;
replace piece1=piece1*12*wkrat1 if V2744==4;
replace piece1=piece1 if V2744==6;
replace piece1=. if V2744>6 | V2744<2;

gen piece2=.;
replace piece2=W3642 if W3642<9999997 & W3642>0;
replace piece2=piece2*hours2 if W3643==1;
replace piece2=piece2*52*wkrat2 if W3643==2; 
replace piece2=piece2*26*wkrat2 if W3643==3;
replace piece2=piece2*12*wkrat2 if W3643==4;
replace piece2=piece2 if W3643==6;
replace piece2=. if W3643>6 | W3643<1;

gen piece3=.;
replace piece3=Q2791 if Q2791<9999997 & Q2791>0;
replace piece3=piece3*hours3 if Q2792==1;
replace piece3=piece3*52*wkrat3 if Q2792==2; 
replace piece3=piece3*26*wkrat3 if Q2792==3;
replace piece3=piece3*12*wkrat3 if Q2792==4;
replace piece3=piece3 if Q2792==6;
replace piece3=. if Q2792>6 | Q2792<1;

gen piece4=.;
replace piece4=Q3314 if Q3314<9999997 & Q3314>0;
replace piece4=piece4*hours4 if Q3315==1;
replace piece4=piece4*52*wkrat4 if Q3315==2; 
replace piece4=piece4*26*wkrat4 if Q3315==3;
replace piece4=piece4*12*wkrat4 if Q3315==4;
replace piece4=piece4 if Q3315==6;
replace piece4=. if Q3315>6 | Q3315<1;

gen piece5=.;
replace piece5=Q3574 if Q3574<9999997 & Q3574>0;
replace piece5=piece5*hours5 if Q3575==1;
replace piece5=piece5*52*wkrat5 if Q3575==2;
replace piece5=piece5*26*wkrat5 if Q3575==3;
replace piece5=piece5*12*wkrat5 if Q3575==4;
replace piece5=piece5 if Q3575==6;
replace piece5=. if Q3575>6 | Q3575<1;

gen piece6=.;
replace piece6=HJ225 if HJ225<999997 & HJ225>0;
replace piece6=piece6*hours6 if HJ226==1;
replace piece6=piece6*52*wkrat6 if HJ226==2;
replace piece6=piece6*26*wkrat6 if HJ226==3;
replace piece6=piece6*12*wkrat6 if HJ226==4;
replace piece6=piece6*24*wkrat6 if HJ226==5;
replace piece6=piece6 if HJ226==6;
replace piece6=. if HJ226>6|HJ226<1;

gen piece7=.;
replace piece7=JJ225 if JJ225<9999997 & JJ225>0;
replace piece7=piece7*hours7 if JJ226==1;
replace piece7=piece7*52*wkrat7 if JJ226==2;
replace piece7=piece7*26*wkrat7 if JJ226==3;
replace piece7=piece7*12*wkrat7 if JJ226==4;
replace piece7=piece7*24*wkrat7 if JJ226==5;
replace piece7=piece7 if JJ226==6;
replace piece7=. if JJ226>6|JJ226<1;

gen piece8=.;
replace piece8=KJ225 if KJ225<9999997 & KJ225>0;
replace piece8=piece8*hours8 if KJ226==1;
replace piece8=piece8*52*wkrat8 if KJ226==2;
replace piece8=piece8*26*wkrat8 if KJ226==3;
replace piece8=piece8*12*wkrat8 if KJ226==4;
replace piece8=piece8*24*wkrat8 if KJ226==5;
replace piece8=piece8 if KJ226==6;
replace piece8=. if KJ226>6|KJ226<1;

gen piece9=.;
replace piece9=LJ225 if LJ225<9999997 & LJ225>0;
replace piece9=piece9*hours9 if LJ226==1;
replace piece9=piece9*52*wkrat9 if LJ226==2;
replace piece9=piece9*26*wkrat9 if LJ226==3;
replace piece9=piece9*12*wkrat9 if LJ226==4;
replace piece9=piece9*24*wkrat9 if LJ226==5;
replace piece9=piece9 if LJ226==6;
replace piece9=. if LJ226>6|LJ226<1;

gen piece10=.;
replace piece10=MJ225 if MJ225<9999997 & MJ225>0;
replace piece10=piece10*hours10 if MJ226==1;
replace piece10=piece10*52*wkrat10 if MJ226==2;
replace piece10=piece10*26*wkrat10 if MJ226==3;
replace piece10=piece10*12*wkrat10 if MJ226==4;
replace piece10=piece10*24*wkrat10 if MJ226==5;
replace piece10=piece10 if MJ226==6;
replace piece10=. if MJ226>6|MJ226<1;

gen piece11=.;
replace piece11=NJ225 if NJ225<9999997 & NJ225>0;
replace piece11=piece11*hours11 if NJ226==1;
replace piece11=piece11*52*wkrat11 if NJ226==2;
replace piece11=piece11*26*wkrat11 if NJ226==3;
replace piece11=piece11*12*wkrat11 if NJ226==4;
replace piece11=piece11*24*wkrat11 if NJ226==5;
replace piece11=piece11 if NJ226==6;
replace piece11=. if NJ226>6|NJ226<1;

gen piece12=.;
replace piece12=OJ225 if OJ225<9999997 & OJ225>0;
replace piece12=piece12*hours12 if OJ226==1;
replace piece12=piece12*52*wkrat12 if OJ226==2;
replace piece12=piece12*26*wkrat12 if OJ226==3;
replace piece12=piece12*12*wkrat12 if OJ226==4;
replace piece12=piece12*24*wkrat12 if OJ226==5;
replace piece12=piece12 if OJ226==6;
replace piece12=. if OJ226>6|OJ226<1;

gen piece13=.;
replace piece13=PJ225 if PJ225<9999997 & PJ225>0;
replace piece13=piece13*hours13 if PJ226==1;
replace piece13=piece13*52*wkrat13 if PJ226==2;
replace piece13=piece13*26*wkrat13 if PJ226==3;
replace piece13=piece13*12*wkrat13 if PJ226==4;
replace piece13=piece13*24*wkrat13 if PJ226==5;
replace piece13=piece13 if PJ226==6;
replace piece13=. if PJ226>6|PJ226<1;

gen piece14=.;
replace piece14=QJ225 if QJ225<9999997 & QJ225>0;
replace piece14=piece14*hours14 if QJ226==1;
replace piece14=piece14*52*wkrat14 if QJ226==2;
replace piece14=piece14*26*wkrat14 if QJ226==3;
replace piece14=piece14*12*wkrat14 if QJ226==4;
replace piece14=piece14*24*wkrat14 if QJ226==5;
replace piece14=piece14 if QJ226==6;
replace piece14=. if QJ226>6|QJ226<1;
if $INCLUDE2020 {; 
gen piece15=.;
replace piece15=RJ225 if RJ225<9999997 & RJ225>0;
replace piece15=piece15*hours15 if RJ226==1;
replace piece15=piece15*52*wkrat15 if RJ226==2;
replace piece15=piece15*26*wkrat15 if RJ226==3;
replace piece15=piece15*12*wkrat15 if RJ226==4;
replace piece15=piece15*24*wkrat15 if RJ226==5;
replace piece15=piece15 if RJ226==6;
replace piece15=. if RJ226>6|RJ226<1;
};

gen wpiece1=piece1/hours1;
gen wpiece2=piece2/hours2;
gen wpiece3=piece3/hours3;
gen wpiece4=piece4/hours4;
gen wpiece5=piece5/hours5;
gen wpiece6=piece6/hours6;
gen wpiece7=piece7/hours7;
gen wpiece8=piece8/hours8;
gen wpiece9=piece9/hours9;
gen wpiece10=piece10/hours10;
gen wpiece11=piece11/hours11;
gen wpiece12=piece12/hours12;
gen wpiece13=piece13/hours13;
gen wpiece14=piece14/hours14;
if $INCLUDE2020 {; 
gen wpiece15=piece15/hours15;
};
* "other": the coding for this one looks treacherous;
gen other1=.;
replace other1=V2748 if V2748<9999997 & V2748>0;
replace other1=other1*52*wkrat1 if V2749==2; 
replace other1=other1*26*wkrat1 if V2749==3;
replace other1=other1*12*wkrat1 if V2749==4;
replace other1=other1 if V2749==6;
replace other1=. if V2749>6 | V2749<2;

gen other2=.;
replace other2=W3645 if W3645<9999997 & W3645>0;
replace other2=other2*hours2 if W3646==1;
replace other2=other2*52*wkrat2 if W3646==2; 
replace other2=other2*26*wkrat2 if W3646==3;
replace other2=other2*12*wkrat2 if W3646==4;
replace other2=other2 if W3646==6;
replace other2=other2*weeks2*5 if W3646==11;
replace other2=. if W3646>11 | W3646<1;

gen other3=.;
replace other3=Q2796 if Q2796<9999997 & Q2796>0;
replace other3=other3*hours3 if Q2797==1;
replace other3=other3*52*wkrat3 if Q2797==2; 
replace other3=other3*26*wkrat3 if Q2797==3;
replace other3=other3*12*wkrat3 if Q2797==4;
replace other3=other3 if Q2797==6;
replace other3=other3*weeks3*5 if Q2797==11;
replace other3=. if Q2797>11 | Q2797<1;

gen other4=.;
replace other4=Q3319 if Q3319<9999997 & Q3319>0;
replace other4=other4*hours4 if Q3320==1;
replace other4=other4*52*wkrat4 if Q3320==2; 
replace other4=other4*26*wkrat4 if Q3320==3;
replace other4=other4*12*wkrat4 if Q3320==4;
replace other4=other4 if Q3320==6;
replace other4=other4*weeks4*5 if Q3320==11;
replace other4=. if Q3320>11 | Q3320<1;

gen other5=.;
replace other5=Q3579 if Q3579<9999997 & Q3579>0;
replace other5=other5*hours5 if Q3580==1;
replace other5=other5*52*wkrat5 if Q3580==2; 
replace other5=other5*26*wkrat5 if Q3580==3;
replace other5=other5*12*wkrat5 if Q3580==4;
replace other5=other5 if Q3580==6;
replace other5=other5*weeks5*5 if Q3580==11;
replace other5=. if Q3580>11 | Q3580<1;

gen other6=.;
replace other6=HJ230 if HJ230<9999997 & HJ230>0;
replace other6=other6*hours6 if HJ231==1;
replace other6=other6*52*wkrat6 if HJ231==2;
replace other6=other6*26*wkrat6 if HJ231==3;
replace other6=other6*12*wkrat6 if HJ231==4;
replace other6=other6*24*wkrat6 if HJ231==5;
replace other6=other6 if HJ231==6;
replace other6=. if HJ231>6 | HJ231<1;

gen other7=.;
replace other7=JJ230 if JJ230<9999997 & JJ230>0;
replace other7=other7*hours7 if JJ231==1;
replace other7=other7*52*wkrat7 if JJ231==2;
replace other7=other7*26*wkrat7 if JJ231==3;
replace other7=other7*12*wkrat7 if JJ231==4;
replace other7=other7*24*wkrat7 if JJ231==5;
replace other7=other7 if JJ231==6;
replace other7=. if JJ231>6 | JJ231<1;

gen other8=.;
replace other8=KJ230 if KJ230<9999997 & KJ230>0;
replace other8=other8*hours8 if KJ231==1;
replace other8=other8*52*wkrat8 if KJ231==2;
replace other8=other8*26*wkrat8 if KJ231==3;
replace other8=other8*12*wkrat8 if KJ231==4;
replace other8=other8*24*wkrat8 if KJ231==5;
replace other8=other8 if KJ231==6;
replace other8=. if KJ231>6 | KJ231<1;

gen other9=.;
replace other9=LJ230 if LJ230<9999997 & LJ230>0;
replace other9=other9*hours9 if LJ231==1;
replace other9=other9*52*wkrat9 if LJ231==2;
replace other9=other9*26*wkrat9 if LJ231==3;
replace other9=other9*12*wkrat9 if LJ231==4;
replace other9=other9*24*wkrat9 if LJ231==5;
replace other9=other9 if LJ231==6;
replace other9=. if LJ231>6 | LJ231<1;

gen other10=.;
replace other10=MJ230 if MJ230<9999997 & MJ230>0;
replace other10=other10*hours10 if MJ231==1;
replace other10=other10*52*wkrat10 if MJ231==2;
replace other10=other10*26*wkrat10 if MJ231==3;
replace other10=other10*12*wkrat10 if MJ231==4;
replace other10=other10*24*wkrat10 if MJ231==5;
replace other10=other10 if MJ231==6;
replace other10=. if MJ231>6 | MJ231<1;

gen other11=.;
replace other11=NJ230 if NJ230<9999997 & NJ230>0;
replace other11=other11*hours11 if NJ231==1;
replace other11=other11*52*wkrat11 if NJ231==2;
replace other11=other11*26*wkrat11 if NJ231==3;
replace other11=other11*12*wkrat11 if NJ231==4;
replace other11=other11*24*wkrat11 if NJ231==5;
replace other11=other11 if NJ231==6;
replace other11=. if NJ231>6 | NJ231<1;

gen other12=.;
replace other12=OJ230 if OJ230<9999997 & OJ230>0;
replace other12=other12*hours12 if OJ231==1;
replace other12=other12*52*wkrat12 if OJ231==2;
replace other12=other12*26*wkrat12 if OJ231==3;
replace other12=other12*12*wkrat12 if OJ231==4;
replace other12=other12*24*wkrat12 if OJ231==5;
replace other12=other12 if OJ231==6;
replace other12=. if OJ231>6 | OJ231<1;

gen other13=.;
replace other13=PJ230 if PJ230<9999997 & PJ230>0;
replace other13=other13*hours13 if PJ231==1;
replace other13=other13*52*wkrat13 if PJ231==2;
replace other13=other13*26*wkrat13 if PJ231==3;
replace other13=other13*12*wkrat13 if PJ231==4;
replace other13=other13*24*wkrat13 if PJ231==5;
replace other13=other13 if PJ231==6;
replace other13=. if PJ231>6 | PJ231<1;

gen other14=.;
replace other14=QJ230 if QJ230<9999997 & QJ230>0;
replace other14=other14*hours14 if QJ231==1;
replace other14=other14*52*wkrat14 if QJ231==2;
replace other14=other14*26*wkrat14 if QJ231==3;
replace other14=other14*12*wkrat14 if QJ231==4;
replace other14=other14*24*wkrat14 if QJ231==5;
replace other14=other14 if QJ231==6;
replace other14=. if QJ231>6 | QJ231<1;
if $INCLUDE2020 {; 
gen other15=.;
replace other15=RJ230 if RJ230<9999997 & RJ230>0;
replace other15=other15*hours15 if RJ231==1;
replace other15=other15*52*wkrat15 if RJ231==2;
replace other15=other15*26*wkrat15 if RJ231==3;
replace other15=other15*12*wkrat15 if RJ231==4;
replace other15=other15*24*wkrat15 if RJ231==5;
replace other15=other15 if RJ231==6;
replace other15=. if RJ231>6 | RJ231<1;
};

gen wother1=other1/hours1;
gen wother2=other2/hours2;
gen wother3=other3/hours3;
gen wother4=other4/hours4;
gen wother5=other5/hours5;
gen wother6=other6/hours6;
gen wother7=other7/hours7;
gen wother8=other8/hours8;
gen wother9=other9/hours9;
gen wother10=other10/hours10;
gen wother11=other11/hours11;
gen wother12=other12/hours12;
gen wother13=other13/hours13;
gen wother14=other14/hours14;
if $INCLUDE2020 {; 
gen wother15=other15/hours15;
};
* wages of the self-employed;

gen se1=.;
replace se1=V2825 if V2825<9999995 & V2825>0;
replace se1=se1*hours1 if V2826==1;
replace se1=se1*52*wkrat1 if V2826==2;
replace se1=se1*26*wkrat1 if V2826==3;
replace se1=se1*12*wkrat1 if V2826==4;
replace se1=se1*24*wkrat1 if V2826==5;
replace se1=se1 if V2826==6;
replace se1=se1*weeks1*5 if V2826==11;
replace se1=. if V2826>11|V2826<1;

gen prof1=.;
replace prof1=V2828 if V2828<9999995 & V2828>0;
replace prof1=prof1*hours1 if V2829==1;
replace prof1=prof1*52*wkrat1 if V2829==2;
replace prof1=prof1*26*wkrat1 if V2829==3;
replace prof1=prof1*12*wkrat1 if V2829==4;
replace prof1=prof1*24*wkrat1 if V2829==5;
replace prof1=prof1 if V2829==6;
replace prof1=prof1*weeks1*5 if V2829==11;
replace prof1=. if V2829>11|V2829<1;

gen se2=.;
replace se2=W4318 if W4318<9999995 & W4318>0;
replace se2=se2*hours2 if W4319==1;
replace se2=se2*52*wkrat2 if W4319==2;
replace se2=se2*26*wkrat2 if W4319==3;
replace se2=se2*12*wkrat2 if W4319==4;
replace se2=se2*24*wkrat2 if W4319==5;
replace se2=se2 if W4319==6;
replace se2=se2*weeks2*5 if W4319==11;
replace se2=. if W4319>11|W4319<1;

gen prof2=.;
replace prof2=W4321 if W4321<9999900 & W4321>0;
replace prof2=prof2*hours2 if W4322==1;
replace prof2=prof2*52*wkrat2 if W4322==2;
replace prof2=prof2*26*wkrat2 if W4322==3;
replace prof2=prof2*12*wkrat2 if W4322==4;
replace prof2=prof2*24*wkrat2 if W4322==5;
replace prof2=prof2 if W4322==6;
replace prof2=prof2*weeks2*5 if W4322==11;
replace prof2=. if W4322>11|W4322<1;

gen se3=.;
replace se3=Q2757 if Q2757<9999995 & Q2757>0;
replace se3=se3*hours3 if Q2758==1;
replace se3=se3*52*wkrat3 if Q2758==2;
replace se3=se3*26*wkrat3 if Q2758==3;
replace se3=se3*12*wkrat3 if Q2758==4;
replace se3=se3*24*wkrat3 if Q2758==5;
replace se3=se3 if Q2758==6;
replace se3=se3*weeks3*5 if Q2758==11;
replace se3=. if Q2758>11|Q2758<1;

gen prof3=.;
replace prof3=Q2761 if Q2761<9999995 & Q2761>0;
replace prof3=prof3*hours3 if Q2762==1;
replace prof3=prof3*52*wkrat3 if Q2762==2;
replace prof3=prof3*26*wkrat3 if Q2762==3;
replace prof3=prof3*12*wkrat3 if Q2762==4;
replace prof3=prof3*24*wkrat3 if Q2762==5;
replace prof3=prof3 if Q2762==6;
replace prof3=prof3*weeks3*5 if Q2762==11;
replace prof3=. if Q2762>11|Q2762<1;

gen se4=.;
replace se4=Q3280 if Q3280<9999995 & Q3280>0;
replace se4=se4*hours4 if Q3281==1;
replace se4=se4*52*wkrat4 if Q3281==2;
replace se4=se4*26*wkrat4 if Q3281==3;
replace se4=se4*12*wkrat4 if Q3281==4;
replace se4=se4*24*wkrat4 if Q3281==5;
replace se4=se4 if Q3281==6;
replace se4=se4*weeks4*5 if Q3281==11;
replace se4=. if Q3281>11|Q3281<1;

gen prof4=.;
replace prof4=Q3284 if Q3284<9999995 & Q3284>0;
replace prof4=prof4*hours4 if Q3285==1;
replace prof4=prof4*52*wkrat4 if Q3285==2;
replace prof4=prof4*26*wkrat4 if Q3285==3;
replace prof4=prof4*12*wkrat4 if Q3285==4;
replace prof4=prof4*24*wkrat4 if Q3285==5;
replace prof4=prof4 if Q3285==6;
replace prof4=prof4*weeks4*5 if Q3285==11;
replace prof4=. if Q3285>11|Q3285<1;

gen se5=.;
replace se5=Q3540 if Q3540<9999995 & Q3540>0;
replace se5=se5*hours5 if Q3541==1;
replace se5=se5*52*wkrat5 if Q3541==2;
replace se5=se5*26*wkrat5 if Q3541==3;
replace se5=se5*12*wkrat5 if Q3541==4;
replace se5=se5*24*wkrat5 if Q3541==5;
replace se5=se5 if Q3541==6;
replace se5=se5*weeks5*5 if Q3541==11;
replace se5=. if Q3541>11|Q3541<1;

gen prof5=.;
replace prof5=Q3544 if Q3544<9999995 & Q3544>0;
replace prof5=prof5*hours5 if Q3545==1;
replace prof5=prof5*52*wkrat5 if Q3545==2;
replace prof5=prof5*26*wkrat5 if Q3545==3;
replace prof5=prof5*12*wkrat5 if Q3545==4;
replace prof5=prof5*24*wkrat5 if Q3545==5;
replace prof5=prof5 if Q3545==6;
replace prof5=prof5*weeks5*5 if Q3545==11;
replace prof5=. if Q3545>11|Q3545<1;

gen se6=.;
replace se6=HJ188 if HJ188<9999995 & HJ188>0;
replace se6=se6*hours6 if HJ192==1;
replace se6=se6*52*wkrat6 if HJ192==2;
replace se6=se6*26*wkrat6 if HJ192==3;
replace se6=se6*12*wkrat6 if HJ192==4;
replace se6=se6*24*wkrat6 if HJ192==5;
replace se6=se6 if HJ192==6;
replace se6=se6*weeks6*5 if HJ192==11;
replace se6=. if HJ192>11|HJ192<1;

gen prof6=.;
replace prof6=HJ195 if HJ195<9999995 & HJ195>0;
replace prof6=prof6*hours6 if HJ199==1;
replace prof6=prof6*52*wkrat6 if HJ199==2;
replace prof6=prof6*26*wkrat6 if HJ199==3;
replace prof6=prof6*12*wkrat6 if HJ199==4;
replace prof6=prof6*24*wkrat6 if HJ199==5;
replace prof6=prof6 if HJ199==6;
replace prof6=prof6*weeks6*5 if HJ199==11;
replace prof6=. if HJ199>11|HJ199<1;

gen se7=.;
replace se7=JJ188 if JJ188<9999995 & JJ188>0;
replace se7=se7*hours7 if JJ192==1;
replace se7=se7*52*wkrat7 if JJ192==2;
replace se7=se7*26*wkrat7 if JJ192==3;
replace se7=se7*12*wkrat7 if JJ192==4;
replace se7=se7*24*wkrat7 if JJ192==5;
replace se7=se7 if JJ192==6;
replace se7=se7*weeks7*5 if JJ192==11;
replace se7=. if JJ192>11|JJ192<1;

gen prof7=.;
replace prof7=JJ195 if JJ195<99999995 & JJ195>0;
replace prof7=prof7*hours7 if JJ199==1;
replace prof7=prof7*52*wkrat7 if JJ199==2;
replace prof7=prof7*26*wkrat7 if JJ199==3;
replace prof7=prof7*12*wkrat7 if JJ199==4;
replace prof7=prof7*24*wkrat7 if JJ199==5;
replace prof7=prof7 if JJ199==6;
replace prof7=prof7*weeks7*5 if JJ199==11;
replace prof7=. if JJ199>11|JJ199<1;

gen se8=.;
replace se8=KJ188 if KJ188<9999995 & KJ188>0;
replace se8=se8*hours8 if KJ192==1;
replace se8=se8*52*wkrat8 if KJ192==2;
replace se8=se8*26*wkrat8 if KJ192==3;
replace se8=se8*12*wkrat8 if KJ192==4;
replace se8=se8*24*wkrat8 if KJ192==5;
replace se8=se8 if KJ192==6;
replace se8=se8*weeks8*5 if KJ192==11;
replace se8=. if KJ192>11|KJ192<1;

gen prof8=.;
replace prof8=KJ195 if KJ195<9999995 & KJ195>0;
replace prof8=prof8*hours8 if KJ199==1;
replace prof8=prof8*52*wkrat8 if KJ199==2;
replace prof8=prof8*26*wkrat8 if KJ199==3;
replace prof8=prof8*12*wkrat8 if KJ199==4;
replace prof8=prof8*24*wkrat8 if KJ199==5;
replace prof8=prof8 if KJ199==6;
replace prof8=prof8*weeks8*5 if KJ199==11;
replace prof8=. if KJ199>11|KJ199<1;

gen se9=.;
replace se9=LJ188 if LJ188<9999995 & LJ188>0;
replace se9=se9*hours9 if LJ192==1;
replace se9=se9*52*wkrat9 if LJ192==2;
replace se9=se9*26*wkrat9 if LJ192==3;
replace se9=se9*12*wkrat9 if LJ192==4;
replace se9=se9*24*wkrat9 if LJ192==5;
replace se9=se9 if LJ192==6;
replace se9=se9*weeks9*5 if LJ192==11;
replace se9=. if LJ192>11|LJ192<1;

gen prof9=.;
replace prof9=LJ195 if LJ195<9999995 & LJ195>0;
replace prof9=prof9*hours9 if LJ199==1;
replace prof9=prof9*52*wkrat9 if LJ199==2;
replace prof9=prof9*26*wkrat9 if LJ199==3;
replace prof9=prof9*12*wkrat9 if LJ199==4;
replace prof9=prof9*24*wkrat9 if LJ199==5;
replace prof9=prof9 if LJ199==6;
replace prof9=prof9*weeks9*5 if LJ199==11;
replace prof9=. if LJ199>11|LJ199<1;

gen se10=.;
replace se10=MJ188 if MJ188<9999995 & MJ188>0;
replace se10=se10*hours10 if MJ192==1;
replace se10=se10*52*wkrat10 if MJ192==2;
replace se10=se10*26*wkrat10 if MJ192==3;
replace se10=se10*12*wkrat10 if MJ192==4;
replace se10=se10*24*wkrat10 if MJ192==5;
replace se10=se10 if MJ192==6;
replace se10=se10*weeks10*5 if MJ192==11;
replace se10=. if MJ192>11|MJ192<1;

gen prof10=.;
replace prof10=MJ195 if MJ195<9999995 & MJ195>0;
replace prof10=prof10*hours10 if MJ199==1;
replace prof10=prof10*52*wkrat10 if MJ199==2;
replace prof10=prof10*26*wkrat10 if MJ199==3;
replace prof10=prof10*12*wkrat10 if MJ199==4;
replace prof10=prof10*24*wkrat10 if MJ199==5;
replace prof10=prof10 if MJ199==6;
replace prof10=prof10*weeks10*5 if MJ199==11;
replace prof10=. if MJ199>11|MJ199<1;

gen se11=.;
replace se11=NJ188 if NJ188<9999995 & NJ188>0;
replace se11=se11*hours11 if NJ192==1;
replace se11=se11*52*wkrat11 if NJ192==2;
replace se11=se11*26*wkrat11 if NJ192==3;
replace se11=se11*12*wkrat11 if NJ192==4;
replace se11=se11*24*wkrat11 if NJ192==5;
replace se11=se11 if NJ192==6;
replace se11=se11*weeks11*5 if NJ192==11;
replace se11=. if NJ192>11|NJ192<1;

gen prof11=.;
replace prof11=NJ195 if NJ195<9999995 & NJ195>0;
replace prof11=prof11*hours11 if NJ199==1;
replace prof11=prof11*52*wkrat11 if NJ199==2;
replace prof11=prof11*26*wkrat11 if NJ199==3;
replace prof11=prof11*12*wkrat11 if NJ199==4;
replace prof11=prof11*24*wkrat11 if NJ199==5;
replace prof11=prof11 if NJ199==6;
replace prof11=prof11*weeks11*5 if NJ199==11;
replace prof11=. if NJ199>11|NJ199<1;

gen se12=.;
replace se12=OJ188 if OJ188<9999995 & OJ188>0;
replace se12=se12*hours12 if OJ192==1;
replace se12=se12*52*wkrat12 if OJ192==2;
replace se12=se12*26*wkrat12 if OJ192==3;
replace se12=se12*12*wkrat12 if OJ192==4;
replace se12=se12*24*wkrat12 if OJ192==5;
replace se12=se12 if OJ192==6;
replace se12=se12*weeks12*5 if OJ192==12;
replace se12=. if OJ192>12|OJ192<1;

gen prof12=.;
replace prof12=OJ195 if OJ195<9999995 & OJ195>0;
replace prof12=prof12*hours12 if OJ199==1;
replace prof12=prof12*52*wkrat12 if OJ199==2;
replace prof12=prof12*26*wkrat12 if OJ199==3;
replace prof12=prof12*12*wkrat12 if OJ199==4;
replace prof12=prof12*24*wkrat12 if OJ199==5;
replace prof12=prof12 if OJ199==6;
replace prof12=prof12*weeks12*5 if OJ199==12;
replace prof12=. if OJ199>12|OJ199<1;

gen se13=.;
replace se13=PJ188 if PJ188<9999995 & PJ188>0;
replace se13=se13*hours13 if PJ192==1;
replace se13=se13*52*wkrat13 if PJ192==2;
replace se13=se13*26*wkrat13 if PJ192==3;
replace se13=se13*12*wkrat13 if PJ192==4;
replace se13=se13*24*wkrat13 if PJ192==5;
replace se13=se13 if PJ192==6;
replace se13=se13*weeks13*5 if PJ192==11;
replace se13=. if PJ192>11|PJ192<1;

gen prof13=.;
replace prof13=PJ195 if PJ195<9999995 & PJ195>0;
replace prof13=prof13*hours13 if PJ199==1;
replace prof13=prof13*52*wkrat13 if PJ199==2;
replace prof13=prof13*26*wkrat13 if PJ199==3;
replace prof13=prof13*12*wkrat13 if PJ199==4;
replace prof13=prof13*24*wkrat13 if PJ199==5;
replace prof13=prof13 if PJ199==6;
replace prof13=prof13*weeks13*5 if PJ199==11;
replace prof13=. if PJ199>11|PJ199<1;

gen se14=.;
replace se14=QJ188 if QJ188<9999995 & QJ188>0;
replace se14=se14*hours14 if QJ192==1;
replace se14=se14*52*wkrat14 if QJ192==2;
replace se14=se14*26*wkrat14 if QJ192==3;
replace se14=se14*12*wkrat14 if QJ192==4;
replace se14=se14*24*wkrat14 if QJ192==5;
replace se14=se14 if QJ192==6;
replace se14=se14*weeks14*5 if QJ192==11;
replace se14=. if QJ192>11|QJ192<1;

gen prof14=.;
replace prof14=QJ195 if QJ195<9999995 & QJ195>0;
replace prof14=prof14*hours14 if QJ199==1;
replace prof14=prof14*52*wkrat14 if QJ199==2;
replace prof14=prof14*26*wkrat14 if QJ199==3;
replace prof14=prof14*12*wkrat14 if QJ199==4;
replace prof14=prof14*24*wkrat14 if QJ199==5;
replace prof14=prof14 if QJ199==6;
replace prof14=prof14*weeks14*5 if QJ199==11;
replace prof14=. if QJ199>11|QJ199<1;

if $INCLUDE2020 {; 
gen se15=.;
replace se15=RJ188 if RJ188<9999995 & RJ188>0;
replace se15=se15*hours15 if RJ192==1;
replace se15=se15*52*wkrat15 if RJ192==2;
replace se15=se15*26*wkrat15 if RJ192==3;
replace se15=se15*12*wkrat15 if RJ192==4;
replace se15=se15*24*wkrat15 if RJ192==5;
replace se15=se15 if RJ192==6;
replace se15=se15*weeks15*5 if RJ192==11;
replace se15=. if RJ192>11|RJ192<1;

gen prof15=.;
replace prof15=RJ195 if RJ195<9999995 & RJ195>0;
replace prof15=prof15*hours15 if RJ199==1;
replace prof15=prof15*52*wkrat15 if RJ199==2;
replace prof15=prof15*26*wkrat15 if RJ199==3;
replace prof15=prof15*12*wkrat15 if RJ199==4;
replace prof15=prof15*24*wkrat15 if RJ199==5;
replace prof15=prof15 if RJ199==6;
replace prof15=prof15*weeks15*5 if RJ199==11;
replace prof15=. if RJ199>11|RJ199<1;
};

gen aa1=se1+prof1;
gen aa2=se2+prof2;
gen aa4=se4+prof4;
gen aa5=se5+prof5;
gen aa6=se6+prof6;
gen aa7=se7+prof7;
gen aa8=se8+prof8;
gen aa9=se9+prof9;
gen aa10=se10+prof10;
gen aa11=se11+prof11;
gen aa12=se12+prof12;
gen aa13=se13+prof13;
gen aa14=se14+prof14;
if $INCLUDE2020 {; 
gen aa15=se15+prof15;
};
/*
* blow off imputing wages for the self-employed for now;

* add up the wage variables;
gen wage1=.;
replace wage1=wsal1 if pay1<20;
replace wage1=wage1+wother1 if (wother1~=. & pay1<20);
replace wage1=wage1+whourly1 if (whourly1~=. & pay1<20);
replace wage1=wage1+wpiece1 if (wpiece1~=. & pay1<20);

replace wage1=whourly1 if (wage1==. & pay1>19);
replace wage1=wage1+wother1 if (wother1~=. & pay1>19);
replace wage1=wage1+wsal1 if (wsal1~=. & pay1>19);
replace wage1=wage1+wpiece1 if (wpiece1~=. & pay1>19);

replace wage1=wpiece1 if (wage1==. & pay1>29);
replace wage1=wage1+wother1 if (wother1~=. & pay1>29);
replace wage1=wage1+wsal1 if (wsal1~=. & pay1>29);
replace wage1=wage1+whourly1 if (whourly1~=. & pay1>29);

replace wage1=wother1 if (wage1==. & pay1>39);
replace wage1=wage1+wpiece1 if (wpiece1~=. & pay1>39);
replace wage1=wage1+wsal1 if (wsal1~=. & pay1>39);
replace wage1=wage1+whourly1 if (whourly1~=. & pay1>39);
*/


replace wsal1=0 if wsal1==.;
replace wother1=0 if wother1==.;
replace whourly1=0 if whourly1==.;
replace wpiece1=0 if wpiece1==.;

replace wsal2=0 if wsal2==.;
replace wother2=0 if wother2==.;
replace whourly2=0 if whourly2==.;
replace wpiece2=0 if wpiece2==.;

replace wsal3=0 if wsal3==.;
replace wother3=0 if wother3==.;
replace whourly3=0 if whourly3==.;
replace wpiece3=0 if wpiece3==.;

replace wsal4=0 if wsal4==.;
replace wother4=0 if wother4==.;
replace whourly4=0 if whourly4==.;
replace wpiece4=0 if wpiece4==.;

replace wsal5=0 if wsal5==.;
replace wother5=0 if wother5==.;
replace whourly5=0 if whourly5==.;
replace wpiece5=0 if wpiece5==.;

replace wsal6=0 if wsal6==.;
replace wother6=0 if wother6==.;
replace whourly6=0 if whourly6==.;
replace wpiece6=0 if wpiece6==.;

replace wsal7=0 if wsal7==.;
replace wother7=0 if wother7==.;
replace whourly7=0 if whourly7==.;
replace wpiece7=0 if wpiece7==.;

replace wsal8=0 if wsal8==.;
replace wother8=0 if wother8==.;
replace whourly8=0 if whourly8==.;
replace wpiece8=0 if wpiece8==.;

replace wsal9=0 if wsal9==.;
replace wother9=0 if wother9==.;
replace whourly9=0 if whourly9==.;
replace wpiece9=0 if wpiece9==.;

replace wsal10=0 if wsal10==.;
replace wother10=0 if wother10==.;
replace whourly10=0 if whourly10==.;
replace wpiece10=0 if wpiece10==.;

replace wsal11=0 if wsal11==.;
replace wother11=0 if wother11==.;
replace whourly11=0 if whourly11==.;
replace wpiece11=0 if wpiece11==.;

replace wsal12=0 if wsal12==.;
replace wother12=0 if wother12==.;
replace whourly12=0 if whourly12==.;
replace wpiece12=0 if wpiece12==.;

replace wsal13=0 if wsal13==.;
replace wother13=0 if wother13==.;
replace whourly13=0 if whourly13==.;
replace wpiece13=0 if wpiece13==.;

replace wsal14=0 if wsal14==.;
replace wother14=0 if wother14==.;
replace whourly14=0 if whourly14==.;
replace wpiece14=0 if wpiece14==.;
if $INCLUDE2020 {; 
replace wsal15=0 if wsal15==.;
replace wother15=0 if wother15==.;
replace whourly15=0 if whourly15==.;
replace wpiece15=0 if wpiece15==.;
};

gen wage1=.;
replace wage1=wsal1+wother1+whourly1+wpiece1;
gen wage2=.;
replace wage2=wsal2+wother2+whourly2+wpiece2;
gen wage3=.;
replace wage3=wsal3+wother3+whourly3+wpiece3;
gen wage4=.;
replace wage4=wsal4+wother4+whourly4+wpiece4;
gen wage5=.;
replace wage5=wsal5+wother5+whourly5+wpiece5;
gen wage6=.;
replace wage6=wsal6+wother6+whourly6+wpiece6;
gen wage7=.;
replace wage7=wsal7+wother7+whourly7+wpiece7;
gen wage8=.;
replace wage8=wsal8+wother8+whourly8+wpiece8;
gen wage9=.;
replace wage9=wsal9+wother9+whourly9+wpiece9;
gen wage10=.;
replace wage10=wsal10+wother10+whourly10+wpiece10;
gen wage11=.;
replace wage11=wsal11+wother11+whourly11+wpiece11;
gen wage12=.;
replace wage12=wsal12+wother12+whourly12+wpiece12;
gen wage13=.;
replace wage13=wsal13+wother13+whourly13+wpiece13;
gen wage14=.;
replace wage14=wsal14+wother14+whourly14+wpiece14;
if $INCLUDE2020 {; 
gen wage15=.;
replace wage15=wsal15+wother15+whourly15+wpiece15;
};







if $INCLUDE2020 {; 
drop RJ*;
};
drop Q* V* W* HJ* J* K* L* M* N* OJ* PJ* QJ*;
sort HHID PN;
save `saved'employ, replace;
summ;
drop _all;

*****************************************************************;
***AHEAD DATA****************************************************;
*****************************************************************;

use `saved'aemploy;

*408C: changed variables starting with V to a capital V to match new AHEAD data, also capitalized OCCG3B;
* this generates a variable=1 if working for someone else, 2 if for self, . if not working;
gen work1=.;
replace work1=V1178 if V1178==1|V1178==2;
gen work2=.;
replace work2=D2653 if D2653==1|D2653==2;

* still working for same employer?;
gen same2=D2747;
replace same2=0 if same2~=1;

gen occ1=OCCG3B;
gen occ2=D2820M;
replace occ2=occ1 if same2==1;
replace occ2=D3254 if work2==2;

gen hours1=V1186;
gen weeks1=V1187;
tab weeks1;
gen hours2=D2836;
gen weeks2=D2846;
gen wkrat1=weeks1/52;
gen wkrat2=weeks2/52;

* recodes for self-emplyed;
replace hours2=D3256 if work2==2;
replace weeks2=D3257 if work2==2;

replace hours1=. if hours1>100|hours1<1;
replace hours1=0 if V1178==0;
tab weeks1;
replace weeks1=. if weeks1>52|weeks1<1;
tab weeks1;
replace weeks1=0 if hours1==0;
tab weeks1;
replace hours1=hours1*weeks1;
replace hours2=. if hours2>95;
replace hours2=0 if D2653==0;
replace weeks2=. if weeks2>52;
replace weeks2=0 if hours2==0;
replace hours2=hours2*weeks2;

gen lfpr1=0;
replace lfpr1=1 if hours1>1;
replace lfpr1=. if hours1==.;
gen lfpr2=0;
replace lfpr2=1 if hours2>1;
replace lfpr2=. if hours2==.;

gen pay1=V1197;
gen pay2=D2860;

* AHEAD wave 1 is simple;
gen sal1=.;
replace sal1=V1189 if V1189<9999997 & V1189>0;
replace sal1=sal1*52*wkrat1 if V1190==1;
replace sal1=sal1*24*wkrat1 if V1190==2;
replace sal1=sal1*12*wkrat1 if V1190==3;
replace sal1=sal1*4*wkrat1 if V1190==4;
replace sal1=sal1*2*wkrat1 if V1190==5;
replace sal1=sal1 if V1190==6;
replace sal1=. if V1190>6 | V1190<1;
gen wage1=sal1/hours1;

gen sal2=.;
replace sal2=D2862 if D2862<9999997 & D2862>0;
replace sal2=(sal2*hours2) if D2863==1;
replace sal2=sal2*52*wkrat2 if D2863==2;
replace sal2=sal2*26*wkrat2 if D2863==3;
replace sal2=sal2*12*wkrat2 if D2863==4;
replace sal2=sal2*24*wkrat1 if D2863==5;
replace sal2=sal2 if D2863==6;
replace sal2=. if D2863>6 | D2863<1;
gen wsal2=sal2/hours2;

gen whourly2=D2870;
replace whourly2=. if whourly2>99994;

gen piece2=.;
replace piece2=D2880 if D2880<9999997 & D2880>0;
replace piece2=piece2*hours2 if D2881==1;
replace piece2=piece2*52*wkrat2 if D2881==2;
replace piece2=piece2*26*wkrat2 if D2881==3;
replace piece2=piece2*12*wkrat2 if D2881==4;
replace piece2=piece2 if D2881==6;
replace piece2=. if D2881>6 | D2881<1;
gen wpiece2=piece2/hours2;

gen other2=.;
replace other2=D2885 if D2885<9999997 & D2885>0;
replace other2=other2*hours2 if D2886==1;
replace other2=other2*52*wkrat2 if D2886==2; 
replace other2=other2*26*wkrat2 if D2886==3;
replace other2=other2*12*wkrat2 if D2886==4;
replace other2=other2*24*wkrat2 if D2886==5;
replace other2=other2 if D2886==6;
replace other2=. if D2886>6 | D2886<1;
gen wother2=other2/hours2;

gen se2=D3261 if D3260==1;
replace se2=. if se2>99999996|D3262>11|D3262<1|D3262==7|D3262==8|D3262==9;
replace se2=se2*hours2 if D3262==1;
replace se2=se2*52 if D3262==2;
replace se2=se2*26 if D3262==3;
replace se2=se2*12 if D3262==4;
replace se2=se2*24 if D3262==5;
replace se2=se2 if D3262==6;
replace se2=se2*(weeks2*5) if D3262==11;

gen prof2=D3265 if D3264==1;
replace prof2=. if prof2>9999996|D3266>6|D3266<1;
replace prof2=prof2*hours2 if D3266==1;
replace prof2=prof2*52 if D3266==2;
replace prof2=prof2*26 if D3266==3;
replace prof2=prof2*12 if D3266==4;
replace prof2=prof2*24 if D3266==5;
replace prof2=prof2 if D3266==6;
* should this really be a - and not a + and why is this not included in wages?
gen aa2=se2+prof2;

replace wsal2=0 if wsal2==.;
replace wother2=0 if wother2==.;
replace whourly2=0 if whourly2==.;
replace wpiece2=0 if wpiece2==.;
gen wage2=.;
replace wage2=wsal2+wother2+whourly2+wpiece2;



drop D*;
summ;

rename wage1 awage1 ;
rename hours1 ahours1 ;
rename sal1 asal1 ;
rename pay1 apay1 ;
rename lfpr1 alfpr1 ;
rename work1 awork1 ;
rename weeks1 aweeks1 ;
rename occ1 aocc1 ;

rename wage2 awage2 ;
rename hours2 ahours2 ;
rename wsal2 awsal2 ;
rename wother2 awother2 ;
rename whourly2 awhourly2 ;
rename wpiece2 awpiece2 ;
rename sal2 asal2 ;
rename other2 aother2 ;
rename piece2 apiece2 ;
rename prof2 aprof2 ;
rename se2 ase2 ;
rename pay2 apay2 ;
rename lfpr2 alfpr2 ;
rename work2 awork2 ;
rename same2 asame2 ;
rename weeks2 aweeks2 ;
rename occ2 aocc2 ;
sort HHID PN;
merge HHID PN using `saved'employ;
drop _merge;

replace wage1=awage1 if wage1==. & awage1~=.;
replace hours1=ahours1 if hours1==. & ahours1~=.;
replace sal1=asal1 if sal1==. & asal1~=.;
replace pay1=apay1 if pay1==. & apay1~=.;
replace lfpr1=alfpr1 if lfpr1==. & alfpr1~=.;
replace work1=awork1 if work1==. & awork1~=.;
tab weeks1;
replace weeks1=aweeks1 if weeks1==. & aweeks1~=.;
tab weeks1;
replace occ1=aocc1 if occ1==. & aocc1~=.;

replace wage2=awage2 if wage2==. & awage2~=.;
replace hours2=ahours2 if hours2==. & ahours2~=.;
replace wsal2=awsal2 if wsal2==. & awsal2~=.;
replace wother2=awother2 if wother2==. & awother2~=.;
replace whourly2=awhourly2 if whourly2==. & awhourly2~=.;
replace wpiece2=awpiece2 if wpiece2==. & awpiece2~=.;
replace sal2=asal2 if sal2==. & asal2~=.;
replace other2=aother2 if other2==. & aother2~=.;
replace piece2=apiece2 if piece2==. & apiece2~=.;
replace prof2=aprof2 if prof2==. & aprof2~=.;
replace se2=ase2 if se2==. & ase2~=.;
replace pay2=apay2 if pay2==. & apay2~=.;
replace lfpr2=alfpr2 if lfpr2==. & alfpr2~=.;
replace work2=awork2 if work2==. & awork2~=.;
replace same2=asame2 if same2==. & asame2~=.;
replace weeks2=aweeks2 if weeks2==. & aweeks2~=.;
replace occ2=aocc2 if occ2==. & aocc2~=.;

drop a* V*;

replace wage1=. if hours1<300;
replace wage1=. if hours1>5000;
replace wage1=. if wage1<3;
replace wage1=. if wage1>200;

replace wage2=. if hours2<300;
replace wage2=. if hours2>5000;
replace wage2=. if wage2<3;
replace wage2=. if wage2>200;

replace wage3=. if hours3<300;
count if hours3==.;
count if hours3>5000;
count if hours3==. & wage3!=.;
count if hours3>5000 & wage3!=.;
count if hours3==. & hours3>5000;
replace wage3=. if hours3>5000;
count if wage3<3;
count if wage3<3 & wage3==0;
replace wage3=. if wage3<3;
replace wage3=. if wage3>200;

replace wage4=. if hours4<300;
replace wage4=. if hours4>5000;
count if wother4==0 & wsal4==0 & whourly4!=0 & wpiece4!=0 & wage4<3;
count if wother4==0 & wsal4!=0 & whourly4==0 & wpiece4!=0 & wage4<3;
count if wother4==0 & wsal4!=0 & whourly4!=0 & wpiece4==0 & wage4<3;
count if wother4==0 & wsal4==0 & whourly4==0 & wpiece4==0 & wage4<3;
count if wother4==0 & wsal4==0 & whourly4==0 & wpiece4!=0 & wage4<3;
count if wother4==0 & wsal4!=0 & whourly4==0 & wpiece4==0 & wage4<3;
count if wother4==0 & wsal4==0 & whourly4!=0 & wpiece4==0 & wage4<3;
count if whourly4==0 & wage4<3;
replace wage4=. if wage4<3;
replace wage4=. if wage4>200;

replace wage5=. if hours5<300;
replace wage5=. if hours5>5000;
replace wage5=. if wage5<3;
replace wage5=. if wage5>200;

replace wage6=. if hours6<300;
replace wage6=. if hours6>5000;
replace wage6=. if wage6<3;
replace wage6=. if wage6>200;

replace wage7=. if hours7<300;
replace wage7=. if hours7>5000;
replace wage7=. if wage7<3;
replace wage7=. if wage7>200;

replace wage8=. if hours8<300;
replace wage8=. if hours8>5000;
replace wage8=. if wage8<3;
replace wage8=. if wage8>200;

replace wage9=. if hours9<300;
replace wage9=. if hours9>5000;
replace wage9=. if wage9<3;
replace wage9=. if wage9>200;

replace wage10=. if hours10<300;
replace wage10=. if hours10>5000;
replace wage10=. if wage10<3;
replace wage10=. if wage10>200;

replace wage11=. if hours11<300;
replace wage11=. if hours11>5000;
replace wage11=. if wage11<3;
replace wage11=. if wage11>200;

replace wage12=. if hours12<300;
replace wage12=. if hours12>5000;
replace wage12=. if wage12<3;
replace wage12=. if wage12>200;

replace wage13=. if hours13<300;
replace wage13=. if hours13>5000;
replace wage13=. if wage13<3;
replace wage13=. if wage13>200;

replace wage14=. if hours14<300;
replace wage14=. if hours14>5000;
replace wage14=. if wage14<3;
replace wage14=. if wage14>200;
if $INCLUDE2020 {; 
replace wage15=. if hours15<300;
replace wage15=. if hours15>5000;
replace wage15=. if wage15<3;
replace wage15=. if wage15>200;
};

gen earn1=wage1*hours1;
gen earn2=wage2*hours2;
gen earn3=wage3*hours3;
gen earn4=wage4*hours4;
gen earn5=wage5*hours5;
gen earn6=wage6*hours6;
gen earn7=wage7*hours7;
gen earn8=wage8*hours8;
gen earn9=wage9*hours9;
gen earn10=wage10*hours10;
gen earn11=wage11*hours11;
gen earn12=wage12*hours12;
gen earn13=wage13*hours13;
gen earn14=wage14*hours14;

replace earn1=0 if hours1<300;
replace earn2=0 if hours2<300;
replace earn3=0 if hours3<300;
replace earn4=0 if hours4<300;
replace earn5=0 if hours5<300;
replace earn6=0 if hours6<300;
replace earn7=0 if hours7<300;
replace earn8=0 if hours8<300;
replace earn9=0 if hours9<300;
replace earn10=0 if hours10<300;
replace earn11=0 if hours11<300;
replace earn12=0 if hours12<300;
replace earn13=0 if hours13<300;
replace earn14=0 if hours14<300;
if $INCLUDE2020 {; 
gen earn15=wage15*hours15;
replace earn15=0 if hours15<300;
};



sort HHID PN; 
save `saved'employ, replace;
cap log close;
* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(employ.xlsx) replace;
cd "$folder\hrs\merge\" ;
use employ.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(employ.xlsx) sheetname(Old);

program drop _all;
*drop _all;

